# Test 5 - Pie chart 2020-05

import pygame
from math import *

title = "Grades for Art 315"
ncategories = 6
maxsize = 20
hlabel = "Grade"
vlabel = "Number"
val = (2, 1, 4, 15, 10, 5)
lab = ("Other", "F", "D", "C", "B", "A")

# Draw a text string at the given point.                       **
def text (s, x, y, size=14, f=None):
    if f == None:                   # Create a font if needed
        f = pygame.font.SysFont(None, size)
    text = f.render(s, 1, (255,255,255))  # Render the string in black
    screen.blit(text, (x, y))

def textsize (s, size=14, f=None):
    if f == None:                   # Create a font if needed
        f = pygame.font.SysFont(None, size)
    text = f.render(s, 1, (0,0,0))  # Render the string in black
    x = text.get_size()[0]
    return x

def label(xx, yy, r, s, m, a1, ap):
    angle = (a1 + ap)/2
    d = r*m
    y = -sin(angle) * d + yy
    x = cos(angle) * d + xx
    text (s, x, y, 20, fonth20)

def pull (x, y, a1, ap):
    angle = (a1 + ap)/2
    d = 12
    y = -sin (angle) * d + y
    x = cos (angle) * d + x
    pieslice (x-5, y-5, x+150, y+150, a1, ap)

def ell(cx, cy, w, h, a1, a2):
    t = a1
    x0 = cx + w / 2 * cos(-t)
    y0 = cy + h / 2 * sin(-t)
    poly = [(x0, y0)]
    while t < a2:
        t = t + 0.0001
        x1 = cx + w / 2 * cos(-t)
        y1 = cy + h / 2 * sin(-t)
#        pygame.draw.line(screen, cf, (x0, y0), (x1, y1), 3)
        x0 = x1
        y0 = y1
        poly.append((x0,y0))
    pygame.draw.polygon (screen, cf, poly)

def pieslice (cx, cy, w, h, a1, a2):
    global cf
    ell(cx, cy, w, h, a1, a2)
    a = b = w/2
    xs = cx + a*cos(-a1)
    ys = cy + b*sin(-a1)
    xe = cx + a*cos(-a2)
    ye = cy + b*sin(-a2)
    pygame.draw.polygon (screen, cf, ((xs,ys),(cx,cy),(xe,ye)))
#    pygame.draw.line(screen, cf, (xs, ys), (cx, cy), 4)
#    pygame.draw.line(screen, cf, (xe, ye), (cx, cy), 4)

width = 600
height = 600
screen = pygame.display.set_mode((width, height))
clock = pygame.time.Clock()
pygame.init()
FPS = 10
fontt14 = pygame.font.SysFont("Times", 14)
fontt24 = pygame.font.SysFont("Times", 24)
fonth20 = pygame.font.SysFont("Helvetica", 20)
fonth24 = pygame.font.SysFont("Helvetica", 24)
r = 255
cf = (255, 200, 200)
conv = 2*3.1415926/360.0
while True:
    clock.tick(FPS)
    mouseX, mouseY = pygame.mouse.get_pos()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            exit()

    screen.fill((180, 180, 180))
    text (title, 200, 30, 24, fonth24)
    cf = (r, 200, 200)
    totalSize = 0
    for i in range (0,ncategories):
        totalSize = totalSize + val[i]
    anglePerCount = 360.0/totalSize
    angle = 0
    r = 255
    cf = (r, 200, 200)
    for i in range(0, ncategories):
            span = val[i]*anglePerCount
            if i == 3:
                pull(300, 300, angle*conv, (angle+span)*conv)
                label (300, 300, 200, lab[i], 1.45, angle*conv, (angle+span)*conv)
            else:
                pieslice(300, 300, 450, 450, angle * conv, (angle + span) * conv)
                label (300, 300, 200, lab[i], 1.25, angle*conv, (angle+span)*conv)
            angle = angle + span
            r = r - 30
            if r<0:
                r = 255
            cf = (r, 200, 200)
    pygame.display.update()
